/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.ntutil.security;

import filenet.vw.ntutil.VWNTUTIL_DLL;
import filenet.vw.ntutil.security.base.IVWNTSSPIServer;
import filenet.vw.ntutil.security.base.IVWNTUtil;
import filenet.vw.ntutil.security.base.NTSecurityToken;
import filenet.vw.ntutil.security.base.NativeSSPIPackage;
import filenet.vw.ntutil.security.base.SSPIClient;
import filenet.vw.ntutil.security.base.SSPISecHandle;
import filenet.vw.ntutil.trace;
import java.rmi.Naming;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;

public class NTSecurity {
    private static boolean ONWINDOWS = false;
    private static String gServer;
    private static int gPort;
    private String m_server = gServer;
    private int m_port = gPort;
    private long m_hToken = 0L;
    private NTSecurityToken m_tokenData = new NTSecurityToken();
    private boolean m_loggedOn = false;
    private IVWNTUtil m_vwNTUtil = null;
    private boolean m_DLLCanBeLoaded = false;

    private static final String getPrivilegedSystemProperty(String propName) {
        final String fpropName = propName;
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(fpropName);
            }
        });
    }

    private static native void initIDs();

    public static synchronized void setServer(String server) {
        gServer = server;
    }

    public static synchronized void setPort(int port) {
        gPort = port;
    }

    private native boolean nativeGetCurrentThreadToken() throws Exception;

    private native boolean nativeLogonAsUser(String var1, String var2) throws Exception;

    private native boolean nativeLogoff();

    private void getVWNTUtil() throws Exception {
        String lookupHost = "rmi://" + this.m_server + ":" + this.m_port + "/" + "VWNTUtil";
        trace.println("looking up VWNTUtil via " + lookupHost);
        try {
            this.m_vwNTUtil = (IVWNTUtil)Naming.lookup(lookupHost);
        }
        catch (Exception e) {
            trace.println("getVWNTUtil exception=" + e.getMessage());
            throw new Exception("SECURITY: Unable to connect to " + lookupHost + ". " + e.getMessage());
        }
    }

    public NTSecurity() {
    }

    public NTSecurity(String server) {
        this.m_server = server;
    }

    public NTSecurity(String server, int port) {
        this.m_server = server;
        this.m_port = port;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NTSecurityToken getCurrentThreadToken() throws Exception {
        SSPIClient client;
        block11: {
            NTSecurityToken nTSecurityToken;
            if (!ONWINDOWS) {
                throw new Exception("SECURITY:  Non-Windows platform.");
            }
            if (!NativeSSPIPackage.init()) {
                throw new Exception("SECURITY: Unable to load library.");
            }
            try {
                if (this.nativeGetCurrentThreadToken()) {
                    return this.m_tokenData;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            client = null;
            try {
                client = this.getSSPIClient();
                if (client == null || !client.authenticate()) break block11;
                SSPISecHandle svrContext = client.getServerContext();
                nTSecurityToken = this.m_tokenData = this.impersonateTest(svrContext);
                Object var5_6 = null;
                if (client == null) return nTSecurityToken;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (client == null) throw throwable;
                client.terminate();
                throw throwable;
            }
            client.terminate();
            return nTSecurityToken;
        }
        Object var5_7 = null;
        if (client == null) throw new Exception("SECURITY: Unable to get current thread token.");
        client.terminate();
        throw new Exception("SECURITY: Unable to get current thread token.");
    }

    public SSPIClient getSSPIClient() throws Exception {
        if (!ONWINDOWS) {
            throw new Exception("SECURITY:  Non-Windows platform.");
        }
        if (NativeSSPIPackage.init()) {
            this.getVWNTUtil();
            IVWNTSSPIServer server = this.m_vwNTUtil.getSSPIServer();
            return new SSPIClient(server);
        }
        throw new Exception("SECURITY: Unable to obtain SSPI client handle.");
    }

    public boolean logonAsUser(String userName, String userPassword) throws Exception {
        if (!ONWINDOWS) {
            throw new Exception("SECURITY:  Non-Windows platform.");
        }
        return this.nativeLogonAsUser(userName, userPassword);
    }

    public boolean logoff() throws Exception {
        if (!ONWINDOWS) {
            throw new Exception("SECURITY:  Non-Windows platform.");
        }
        return this.nativeLogoff();
    }

    public static void release() {
        if (ONWINDOWS) {
            trace.println("NTSecurity.release(E)");
            NativeSSPIPackage.release();
            trace.println("NTSecurity.release(X)");
        }
    }

    public NTSecurityToken impersonateTest(SSPISecHandle svrContext) throws Exception {
        this.getVWNTUtil();
        return this.m_vwNTUtil.impersonateTest(svrContext);
    }

    public static void main(String[] args) {
        try {
            NTSecurity test;
            NTSecurityToken tokenInfo;
            String server = "localhost";
            String user = null;
            String password = "";
            if (args != null) {
                if (args.length > 0 && (args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("/h"))) {
                    trace.println("usage:  NTSecurity [server [user [password]]]");
                    System.exit(0);
                }
                if (args.length > 2) {
                    password = args[2];
                }
                if (args.length > 1) {
                    user = args[1];
                }
                if (args.length > 0) {
                    server = args[0];
                }
            }
            if ((tokenInfo = (test = new NTSecurity(server)).getCurrentThreadToken()) != null) {
                trace.println("NTSecurity Initially, who amI? = " + tokenInfo.toString());
            } else {
                trace.println("NTSecurity Initially, no token ?");
            }
            if (user != null) {
                trace.println("NTSecurity  main, need to logon! with name=" + user + ", pw=" + password);
                if (test.logonAsUser(user, password)) {
                    trace.println("NTSecurity  main, logonAsUser SUCCESSFUL!");
                } else {
                    trace.println("NTSecurity  main, logonAsUser FAILED!");
                }
            }
            if ((tokenInfo = test.getCurrentThreadToken()) != null) {
                trace.println("NTSecurity getCurrentThreadToken AFTER LOGON get userName = " + tokenInfo.getUserName() + ", domain=" + tokenInfo.getDomainName());
            } else {
                trace.println("No token ?");
            }
            for (int j = 0; j < 5; ++j) {
                SSPIClient client = test.getSSPIClient();
                trace.println("NTSecurity, calling SSPIClient.authenticate!");
                if (client.authenticate()) {
                    trace.println("NTSecurity, getting serverCOntext");
                    SSPISecHandle svrContext = client.getServerContext();
                    NTSecurityToken testString = test.impersonateTest(svrContext);
                    if (testString != null) {
                        System.out.println("main: impersonateTest returns " + testString.toString());
                    } else {
                        trace.println("What!! main:impersonateTest failed?");
                    }
                }
                client.terminate();
            }
            test.logoff();
            tokenInfo = test.getCurrentThreadToken();
            if (tokenInfo != null) {
                trace.println("NTSecurity AFTER Logoff, who amI? = " + tokenInfo.toString());
            } else {
                trace.println("NTSecurity AFTER Logoff, no token ?");
            }
            test.release();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    static {
        String s = NTSecurity.getPrivilegedSystemProperty("os.name");
        if (s != null) {
            boolean bl = ONWINDOWS = s.toUpperCase(Locale.ENGLISH).indexOf("WINDOWS") > -1;
        }
        if (ONWINDOWS && VWNTUTIL_DLL.initLibrary()) {
            NTSecurity.initIDs();
        }
        gServer = "localhost";
        gPort = 32771;
    }
}

